VERSION 5.00
Object = "{7F0DC2FA-DACB-4A76-B3C3-86A36AB1228A}#1.0#0"; "LEDMeter.ocx"
Begin VB.Form Form1 
   BackColor       =   &H00FFFFFF&
   Caption         =   "VU Meter"
   ClientHeight    =   8610
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   10935
   Icon            =   "Form1.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   8610
   ScaleWidth      =   10935
   StartUpPosition =   3  'Windows Default
   Begin LEDMETERLib.LEDMeter LEDMeter2 
      Height          =   5055
      Left            =   3840
      TabIndex        =   10
      Top             =   2760
      Width           =   3375
      _Version        =   65536
      _ExtentX        =   5953
      _ExtentY        =   8916
      _StockProps     =   0
   End
   Begin LEDMETERLib.LEDMeter LEDMeter1 
      Height          =   5055
      Left            =   240
      TabIndex        =   9
      Top             =   2760
      Width           =   3375
      _Version        =   65536
      _ExtentX        =   5953
      _ExtentY        =   8916
      _StockProps     =   0
   End
   Begin VUmeter.isButton command4 
      Height          =   615
      Left            =   9480
      TabIndex        =   8
      Top             =   7920
      Width           =   1335
      _ExtentX        =   2355
      _ExtentY        =   1085
      Icon            =   "Form1.frx":058A
      Style           =   10
      Caption         =   "EXIT"
      IconAlign       =   1
      iNonThemeStyle  =   0
      Tooltiptitle    =   ""
      ToolTipIcon     =   0
      ToolTipType     =   0
      ttForeColor     =   0
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Verdana"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VUmeter.isButton Command3 
      Height          =   615
      Left            =   8160
      TabIndex        =   7
      Top             =   7920
      Width           =   1335
      _ExtentX        =   2355
      _ExtentY        =   1085
      Icon            =   "Form1.frx":05A6
      Style           =   10
      Caption         =   "RESET"
      IconAlign       =   1
      iNonThemeStyle  =   0
      Tooltiptitle    =   ""
      ToolTipIcon     =   0
      ToolTipType     =   0
      ttForeColor     =   0
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Verdana"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VUmeter.isButton Command2 
      Height          =   615
      Left            =   6840
      TabIndex        =   6
      Top             =   7920
      Width           =   1335
      _ExtentX        =   2355
      _ExtentY        =   1085
      Icon            =   "Form1.frx":05C2
      Style           =   10
      Caption         =   "STOP"
      IconAlign       =   1
      iNonThemeStyle  =   0
      Tooltiptitle    =   ""
      ToolTipIcon     =   0
      ToolTipType     =   0
      ttForeColor     =   0
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Verdana"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VUmeter.isButton Command1 
      Height          =   615
      Left            =   5520
      TabIndex        =   5
      Top             =   7920
      Width           =   1335
      _ExtentX        =   2355
      _ExtentY        =   1085
      Style           =   10
      Caption         =   "START"
      IconAlign       =   1
      iNonThemeStyle  =   0
      Tooltiptitle    =   ""
      ToolTipIcon     =   0
      ToolTipType     =   0
      ttForeColor     =   0
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Verdana"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.Frame Frame2 
      BackColor       =   &H00FFFFFF&
      Caption         =   "SETTINGS"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1695
      Left            =   5760
      TabIndex        =   0
      Top             =   120
      Width           =   4575
      Begin VB.OptionButton Option2 
         BackColor       =   &H00FFFFFF&
         Caption         =   "RIGHT"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Left            =   3120
         TabIndex        =   21
         Top             =   1200
         Width           =   975
      End
      Begin VB.OptionButton Option1 
         BackColor       =   &H00FFFFFF&
         Caption         =   "LEFT"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Left            =   1920
         TabIndex        =   20
         Top             =   1200
         Width           =   1095
      End
      Begin VB.ComboBox Combo2 
         Height          =   315
         ItemData        =   "Form1.frx":05DE
         Left            =   1320
         List            =   "Form1.frx":05E8
         TabIndex        =   4
         Text            =   "378"
         Top             =   840
         Width           =   3135
      End
      Begin VB.ComboBox Combo1 
         Height          =   315
         Left            =   1320
         TabIndex        =   1
         Text            =   "Combo1"
         Top             =   360
         Width           =   3135
      End
      Begin VB.Label Label11 
         BackStyle       =   0  'Transparent
         Caption         =   "Sample channel :"
         Height          =   255
         Left            =   240
         TabIndex        =   19
         Top             =   1320
         Width           =   1335
      End
      Begin VB.Label Label2 
         BackStyle       =   0  'Transparent
         Caption         =   "Printer port :"
         Height          =   255
         Left            =   360
         TabIndex        =   3
         Top             =   840
         Width           =   855
      End
      Begin VB.Label Label1 
         BackStyle       =   0  'Transparent
         Caption         =   "Audio devices :"
         Height          =   195
         Left            =   120
         TabIndex        =   2
         Top             =   420
         Width           =   1095
      End
   End
   Begin VB.Label Label10 
      BackStyle       =   0  'Transparent
      Caption         =   "LIGHT 8"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   8880
      TabIndex        =   18
      Top             =   3840
      Width           =   1095
   End
   Begin VB.Label Label9 
      BackStyle       =   0  'Transparent
      Caption         =   "LIGHT 7"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   8880
      TabIndex        =   17
      Top             =   4320
      Width           =   1095
   End
   Begin VB.Label Label8 
      BackStyle       =   0  'Transparent
      Caption         =   "LIGHT 6"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   8880
      TabIndex        =   16
      Top             =   4800
      Width           =   1215
   End
   Begin VB.Label Label7 
      BackStyle       =   0  'Transparent
      Caption         =   "LIGHT 5"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   8880
      TabIndex        =   15
      Top             =   5280
      Width           =   1095
   End
   Begin VB.Label Label6 
      BackStyle       =   0  'Transparent
      Caption         =   "LIGHT 4"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   8880
      TabIndex        =   14
      Top             =   5760
      Width           =   1095
   End
   Begin VB.Label Label5 
      BackStyle       =   0  'Transparent
      Caption         =   "LIGHT 3"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   8880
      TabIndex        =   13
      Top             =   6240
      Width           =   1095
   End
   Begin VB.Label Label4 
      BackStyle       =   0  'Transparent
      Caption         =   "LIGHT 2"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   8880
      TabIndex        =   12
      Top             =   6720
      Width           =   1095
   End
   Begin VB.Label Label3 
      BackStyle       =   0  'Transparent
      Caption         =   "LIGHT 1"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   8880
      TabIndex        =   11
      Top             =   7200
      Width           =   1095
   End
   Begin VB.Shape Shape8 
      BorderColor     =   &H00000000&
      BorderWidth     =   3
      FillColor       =   &H00808080&
      FillStyle       =   0  'Solid
      Height          =   375
      Left            =   8160
      Shape           =   3  'Circle
      Top             =   3840
      Width           =   375
   End
   Begin VB.Shape Shape5 
      BorderColor     =   &H00000000&
      BorderWidth     =   3
      FillColor       =   &H00808080&
      FillStyle       =   0  'Solid
      Height          =   375
      Left            =   8160
      Shape           =   3  'Circle
      Top             =   5280
      Width           =   375
   End
   Begin VB.Shape Shape7 
      BorderColor     =   &H00000000&
      BorderWidth     =   3
      FillColor       =   &H00808080&
      FillStyle       =   0  'Solid
      Height          =   375
      Left            =   8160
      Shape           =   3  'Circle
      Top             =   4320
      Width           =   375
   End
   Begin VB.Shape Shape6 
      BorderColor     =   &H00000000&
      BorderWidth     =   3
      FillColor       =   &H00808080&
      FillStyle       =   0  'Solid
      Height          =   375
      Left            =   8160
      Shape           =   3  'Circle
      Top             =   4800
      Width           =   375
   End
   Begin VB.Shape Shape3 
      BorderColor     =   &H00000000&
      BorderWidth     =   3
      FillColor       =   &H00808080&
      FillStyle       =   0  'Solid
      Height          =   375
      Left            =   8160
      Shape           =   3  'Circle
      Top             =   6240
      Width           =   375
   End
   Begin VB.Shape Shape2 
      BorderColor     =   &H00000000&
      BorderWidth     =   3
      FillColor       =   &H00808080&
      FillStyle       =   0  'Solid
      Height          =   375
      Left            =   8160
      Shape           =   3  'Circle
      Top             =   6720
      Width           =   375
   End
   Begin VB.Shape Shape1 
      BorderColor     =   &H00000000&
      BorderWidth     =   3
      FillColor       =   &H00808080&
      FillStyle       =   0  'Solid
      Height          =   375
      Left            =   8160
      Shape           =   3  'Circle
      Top             =   7200
      Width           =   375
   End
   Begin VB.Shape Shape4 
      BorderColor     =   &H00000000&
      BorderWidth     =   3
      FillColor       =   &H00808080&
      FillStyle       =   0  'Solid
      Height          =   375
      Left            =   8160
      Shape           =   3  'Circle
      Top             =   5760
      Width           =   375
   End
   Begin VB.Image Image8 
      Height          =   735
      Left            =   9480
      Picture         =   "Form1.frx":05F6
      Top             =   2760
      Width           =   765
   End
   Begin VB.Image Image7 
      Height          =   1065
      Left            =   7920
      Picture         =   "Form1.frx":2414
      Top             =   2640
      Width           =   1350
   End
   Begin VB.Image Image6 
      Height          =   810
      Left            =   6600
      Picture         =   "Form1.frx":6FC6
      Top             =   1920
      Width           =   765
   End
   Begin VB.Image Image5 
      Height          =   540
      Left            =   3840
      Picture         =   "Form1.frx":90F0
      Top             =   2160
      Width           =   2775
   End
   Begin VB.Image Image4 
      Height          =   600
      Left            =   1080
      Picture         =   "Form1.frx":DF62
      Top             =   2160
      Width           =   2520
   End
   Begin VB.Image Image3 
      Height          =   810
      Left            =   240
      Picture         =   "Form1.frx":12E64
      Top             =   1920
      Width           =   765
   End
   Begin VB.Image Image2 
      Height          =   570
      Left            =   240
      Picture         =   "Form1.frx":14F8E
      Top             =   7920
      Width           =   5130
   End
   Begin VB.Image Image1 
      Height          =   2040
      Left            =   120
      Picture         =   "Form1.frx":1E868
      Top             =   0
      Width           =   5130
   End
   Begin VB.Shape Shape9 
      Height          =   5415
      Left            =   7680
      Top             =   2400
      Width           =   2655
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private Declare Sub Out Lib "inpout32.dll" Alias "Out32" (ByVal PortAddress As Integer, ByVal Value As Integer)
Option Explicit
Dim DevHandle As Long
Dim InData(0 To 511) As Byte
Dim Inited As Boolean
Dim MinHeight As Long, MinWidth As Long
Dim lngTempTime
Dim Left_d As Byte
Dim Right_d As Byte
Dim sample_ch As Byte

Private Sub EnumDevices()
    Dim wicCaps As WaveInCaps
    Dim lngNumDev As Long
    Dim ret As Long
    
    Combo1.Clear
    
    'find out how many sound devices there are on the system,
    'and get their names.
    For lngNumDev = 0 To waveInGetNumDevs - 1
        ret = waveInGetDevCaps(lngNumDev, VarPtr(wicCaps), Len(wicCaps))
        'If wicCaps.Formats And WAVE_FORMAT_1M08 Then
        If wicCaps.Formats And WAVE_FORMAT_1S08 Then 'Now is 1S08 -- Check for devices that can do stereo 8-bit 11kHz
           Combo1.AddItem StrConv(wicCaps.ProductName, vbUnicode) & Str(lngNumDev)
        End If
    Next
    '
    'If none are found, then do something appropriate...
    '
    If Combo1.ListCount = 0 Then
        'tell the user about it.
        MsgBox "No audio devices were found on your system.", vbCritical
        'grey out the start button to prevent the user forcing the
        'system to do something it can't
        Command1.Enabled = False
        'Jump out of the subroutine...
        Exit Sub
    End If
    '
    'Set the default in the combo as device 0. This will ordinarily
    'be the only one of course as not many people have 2 sound cards.
    '
    Combo1.ListIndex = 0
    'Update the GUI
    DoEvents
    
End Sub

Private Sub Command1_Click() 'START
   Combo1.Enabled = False
   Combo2.Enabled = False
   
   Dim ret As Long
   'First, we need to define a WaveFormat data type. We will pass this to
   'the sound driver so it knows what we want it to do.
   '
   Dim WaveFormat As WaveFormatEx
   ' then populate it with values.
   ' We are setting it up for 11025/8bit/stereo.
   '
   With WaveFormat
      .FormatTag = WAVE_FORMAT_PCM
      .Channels = 2
      .SamplesPerSec = 22050 '22.05khz
      .BitsPerSample = 8
      .BlockAlign = (.Channels * .BitsPerSample) \ 8
      .AvgBytesPerSec = .BlockAlign * .SamplesPerSec
      .ExtraDataSize = 0
   End With
   '
   'Next, we will pass this to the sound driver along with the name of the
   'device we want to open- which is the NUMBER of the device determined
   'during enumeration.
   'waveInOpen will open the device in input (record) mode, and
   'tell us the handle Windows allocated. If this number is zero, this
   'means the task failed for some reason.
   '
   ret = waveInOpen(DevHandle, Combo1.ListIndex, VarPtr(WaveFormat), 0, 0, 0)
   ' so check the value of DevHandle, and if it is 0 tell the user then
   'jump out of this routine.
   '
   If DevHandle = 0 Then
      MsgBox "Wave input device failed to open", vbCritical
      Exit Sub
   End If
   '
   'OK to proceed. The opened device can now be started
   '
   ret = waveInStart(DevHandle)
   '
   ' then go onto the capture loop
   Call Capture
End Sub

Private Sub Command2_Click() 'STOP
    'The stop button has been pressed:
    'need to cleanly close the audio device.
    Dim ret As Long
    ret = waveInReset(DevHandle)
    ret = waveInClose(DevHandle)
    'set the handle to 0 which will terminate the capture loop
    DevHandle = 0
    'tidy up the progress bars display
    LEDMeter1.Reset
    LEDMeter2.Reset
    Combo1.Enabled = True
    Combo2.Enabled = True
    Shape1.FillColor = &H808080     'grey
    Shape2.FillColor = &H808080     'grey
    Shape3.FillColor = &H808080     'grey
    Shape4.FillColor = &H808080     'grey
    Shape5.FillColor = &H808080     'grey
    Shape6.FillColor = &H808080     'grey
    Shape7.FillColor = &H808080     'grey
    Shape8.FillColor = &H808080     'grey
    Out Val("&H" & Val(Combo2.Text)), Val(0)
End Sub

Private Sub Command3_Click() 'RESET
LEDMeter1.Reset
LEDMeter2.Reset
Shape1.FillColor = &H808080     'grey
Shape2.FillColor = &H808080     'grey
Shape3.FillColor = &H808080     'grey
Shape4.FillColor = &H808080     'grey
Shape5.FillColor = &H808080     'grey
Shape6.FillColor = &H808080     'grey
Shape7.FillColor = &H808080     'grey
Shape8.FillColor = &H808080     'grey
Out Val("&H" & Val(Combo2.Text)), Val(0)
End Sub

Private Sub command4_Click() 'EXIT
'we must stop and cleanly close the audio device.
Dim ret As Long
ret = waveInReset(DevHandle)
ret = waveInClose(DevHandle)
'set the handle to 0 which will terminate the capture loop
DevHandle = 0
DoEvents
Out Val("&H" & Val(Combo2.Text)), Val(0)
End
End Sub

Private Sub Form_Load()
   'On application start, find out what sound devices are available.
   Call EnumDevices
   'set up the progress bars.
   LEDMeter1.Reset
   LEDMeter2.Reset
   Combo1.Enabled = True
   Combo2.Enabled = True
   Combo2.Text = 378
   Out Val("&H" & Val(Combo2.Text)), Val(0)
   Option1.Value = True
End Sub

Private Sub Capture()
   Dim Wave As WaveHdr
   Dim ret As Long
   Dim i As Long
   
   '
   Wave.lpData = VarPtr(InData(0))
   'set the buffer up to be 512 8-bit words long.
   'Each word (octet) represents one sample, which can have
   '256 values- 127 represents the mid-point value, and the sample
   'values swing above and below this on positive and negative
   'half-cycles of the audio waveform.
   '
   'The reason we need 512 bytes is because we are going to ask the
   'sound driver to fill the buffer for us, and it will do this in the order:
   'Left sample #0 - right sample #0 - Left sample #1 - right sample #1 ..... Left sample #255 - right sample #255.
   '
   Wave.dwBufferLength = 512
   '
   '
   'go into a loop
   '
   Do
     'These two API calls start the capture process.
     'The sound driver will fill the buffer as described before..
     ret = waveInPrepareHeader(DevHandle, VarPtr(Wave), Len(Wave))
     ret = waveInAddBuffer(DevHandle, VarPtr(Wave), Len(Wave))
     '
     'and we have to wait for this to happen. When the buffer is full,
     'the condition in the loop until below will be satisfied.
     '
     Do
        'wait 50 milliseconds
        lngTempTime = timeGetTime
        Do Until timeGetTime > lngTempTime + 50
           'loop until 50mS has elapsed
        Loop
        'then test the flags to see if buffer filled. If not wait again..
     Loop Until ((Wave.dwFlags And WHDR_DONE) = WHDR_DONE) Or DevHandle = 0
     '
     'The buffer must now be full, or Stop has been clicked...
     'Stop the capture process
     ret = waveInUnprepareHeader(DevHandle, VarPtr(Wave), Len(Wave))
     '
     'need to process some other eventualities..
     '
     If DevHandle = 0 Then
        'The device has closed...
        'either on its own due to an error or the stop button was clicked.
        'Either way, jump out of the loop
        Exit Do
     End If
     '
     'but if not, we know a bufferfull has been captured:
     'so let's look at what we've got!
     '
     For i = 0 To 255
         'go through the buffer and see what the samples are.
         'Larmit would look at the values in the buffer to
         'see if there was a signal or not.
         '
         'As a suggestion, I'm going to set the background colour
         'of label2 to red if any of the samples is > the value in the
         'text box text1. This is set to some suitable value to allow for
         'noise which might give samples other than 127, I don't know...
         'I guess this depends on the card. In this demo
         'it only samples positive-going half cycles in the left-hand
         'channel.
         '
         'This bit just waggles the 'progress bars' with the samples
         '
         'Left hand channel (even samples)
         Left_d = Abs((InData(i * 2) * 100) / 256)
         LEDMeter1.SetLevel Left_d
         'right hand channel (odd samples)
         Right_d = Abs((InData((i * 2) + 1) * 100) / 256)
         LEDMeter2.SetLevel Right_d
         
         If Option1.Value = True Then
         sample_ch = Left_d 'select left channel for sampling
         Else
         sample_ch = Right_d 'select right channel for sampling
         End If
         
         If sample_ch <= 52 Then 'all lights OFF
         Shape1.FillColor = &H808080     'grey
         Shape2.FillColor = &H808080     'grey
         Shape3.FillColor = &H808080     'grey
         Shape4.FillColor = &H808080     'grey
         Shape5.FillColor = &H808080     'grey
         Shape6.FillColor = &H808080     'grey
         Shape7.FillColor = &H808080     'grey
         Shape8.FillColor = &H808080     'grey
         Out Val("&H" & Val(Combo2.Text)), Val(0)
         
         ElseIf sample_ch > 52 And sample_ch <= 56 Then 'upto light 1 ON
         Shape1.FillColor = &HFF00&  'green
         Shape2.FillColor = &H808080     'grey
         Shape3.FillColor = &H808080     'grey
         Shape4.FillColor = &H808080     'grey
         Shape5.FillColor = &H808080     'grey
         Shape6.FillColor = &H808080     'grey
         Shape7.FillColor = &H808080     'grey
         Shape8.FillColor = &H808080     'grey
         Out Val("&H" & Val(Combo2.Text)), Val(1)
         
         ElseIf sample_ch > 56 And sample_ch <= 62 Then 'upto light 2 ON
         Shape1.FillColor = &HFF00&  'green
         Shape2.FillColor = &HFF00&  'green
         Shape3.FillColor = &H808080     'grey
         Shape4.FillColor = &H808080     'grey
         Shape5.FillColor = &H808080     'grey
         Shape6.FillColor = &H808080     'grey
         Shape7.FillColor = &H808080     'grey
         Shape8.FillColor = &H808080     'grey
         Out Val("&H" & Val(Combo2.Text)), Val(3)
         
         ElseIf sample_ch > 62 And sample_ch <= 68 Then 'upto light 3 ON
         Shape1.FillColor = &HFF00&  'green
         Shape2.FillColor = &HFF00&  'green
         Shape3.FillColor = &HFF00&  'green
         Shape4.FillColor = &H808080     'grey
         Shape5.FillColor = &H808080     'grey
         Shape6.FillColor = &H808080     'grey
         Shape7.FillColor = &H808080     'grey
         Shape8.FillColor = &H808080     'grey
         Out Val("&H" & Val(Combo2.Text)), Val(7)
         
         ElseIf sample_ch > 68 And sample_ch <= 74 Then 'upto light 4 ON
         Shape1.FillColor = &HFF00&  'green
         Shape2.FillColor = &HFF00&  'green
         Shape3.FillColor = &HFF00&  'green
         Shape4.FillColor = &HFF00&  'green
         Shape5.FillColor = &H808080     'grey
         Shape6.FillColor = &H808080     'grey
         Shape7.FillColor = &H808080     'grey
         Shape8.FillColor = &H808080     'grey
         Out Val("&H" & Val(Combo2.Text)), Val(15)
         
         ElseIf sample_ch > 74 And sample_ch <= 80 Then 'upto light 5 ON
         Shape1.FillColor = &HFF00&  'green
         Shape2.FillColor = &HFF00&  'green
         Shape3.FillColor = &HFF00&  'green
         Shape4.FillColor = &HFF00&  'green
         Shape5.FillColor = &HFF00&  'green
         Shape6.FillColor = &H808080     'grey
         Shape7.FillColor = &H808080     'grey
         Shape8.FillColor = &H808080     'grey
         Out Val("&H" & Val(Combo2.Text)), Val(31)
         
         ElseIf sample_ch > 80 And sample_ch <= 86 Then 'upto light 6 ON
         Shape1.FillColor = &HFF00&  'green
         Shape2.FillColor = &HFF00&  'green
         Shape3.FillColor = &HFF00&  'green
         Shape4.FillColor = &HFF00&  'green
         Shape5.FillColor = &HFF00&  'green
         Shape6.FillColor = &HFF00&  'green
         Shape7.FillColor = &H808080     'grey
         Shape8.FillColor = &H808080     'grey
         Out Val("&H" & Val(Combo2.Text)), Val(63)
         
         ElseIf sample_ch > 86 And sample_ch <= 92 Then 'upto light 7 ON
         Shape1.FillColor = &HFF00&  'green
         Shape2.FillColor = &HFF00&  'green
         Shape3.FillColor = &HFF00&  'green
         Shape4.FillColor = &HFF00&  'green
         Shape5.FillColor = &HFF00&  'green
         Shape6.FillColor = &HFF00&  'green
         Shape7.FillColor = &HFF00&  'green
         Shape8.FillColor = &H808080     'grey
         Out Val("&H" & Val(Combo2.Text)), Val(127)
         
         ElseIf sample_ch > 92 And sample_ch <= 100 Then 'upto light 8 ON
         Shape1.FillColor = &HFF00&  'green
         Shape2.FillColor = &HFF00&  'green
         Shape3.FillColor = &HFF00&  'green
         Shape4.FillColor = &HFF00&  'green
         Shape5.FillColor = &HFF00&  'green
         Shape6.FillColor = &HFF00&  'green
         Shape7.FillColor = &HFF00&  'green
         Shape8.FillColor = &HFF00&  'green
         Out Val("&H" & Val(Combo2.Text)), Val(255)
         
         End If
                       
         Next
        
     'allow windows to update the gui.
     DoEvents
  Loop While DevHandle <> 0 'While the audio device is open

End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
   'User has clicked the X on the form to close it.
   'we must stop and cleanly close the audio device.
   Dim ret As Long
   ret = waveInReset(DevHandle)
   ret = waveInClose(DevHandle)
   'set the handle to 0 which will terminate the capture loop
   DevHandle = 0
   DoEvents
End Sub

